<?php $__env->startSection('title', 'System Update'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .update-card {
        max-width: 800px;
        margin: 20px auto;
    }
    
    .version-badge {
        font-size: 24px;
        padding: 10px 20px;
        border-radius: 8px;
    }
    
    .update-progress {
        display: none;
        margin-top: 20px;
    }
    
    .update-step {
        padding: 15px;
        margin: 10px 0;
        border-radius: 5px;
        background: #f8f9fa;
        border-left: 4px solid #6c757d;
    }
    
    .update-step.success {
        border-left-color: #28a745;
        background: #d4edda;
    }
    
    .update-step.error {
        border-left-color: #dc3545;
        background: #f8d7da;
    }
    
    .update-step.processing {
        border-left-color: #007bff;
        background: #cfe2ff;
    }
    
    .changelog-item {
        padding: 20px;
        margin: 15px 0;
        border-radius: 8px;
        background: #fff;
        border: 2px solid #dee2e6;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
    }
    
    .changelog-item:hover {
        box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        transform: translateY(-2px);
    }
    
    .changelog-item.border-success {
        border-color: #28a745;
        background: linear-gradient(135deg, #ffffff 0%, #f8fff9 100%);
    }
    
    .changelog-item.border-primary {
        border-color: #007bff;
        background: linear-gradient(135deg, #ffffff 0%, #f8fcff 100%);
    }
    
    .changelog-item h5 {
        color: #2c3e50;
        margin-bottom: 15px;
        font-weight: 600;
    }
    
    .changelog-item h6 {
        margin-top: 15px;
        margin-bottom: 8px;
        font-weight: 600;
    }
    
    .changelog-item ul li {
        margin-bottom: 5px;
        padding-left: 5px;
    }
    
    .spinner-border-custom {
        width: 20px;
        height: 20px;
        border-width: 2px;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('main'); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">System Update</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">System Update</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<section class="content">
    <div class="container-fluid">
        
        <!-- Current Version Card -->
        <div class="card update-card">
            <div class="card-header bg-primary">
                <h3 class="card-title"><i class="fas fa-info-circle"></i> System Information</h3>
            </div>
            <div class="card-body text-center">
                <div class="row">
                    <div class="col-md-6">
                        <h5>Current Version</h5>
                        <span class="badge badge-secondary version-badge">
                            <i class="fas fa-code-branch"></i> v<?php echo e($currentVersion); ?>

                        </span>
                    </div>
                    <div class="col-md-6">
                        <h5>Latest Version</h5>
                        <span class="badge <?php echo e($updateAvailable ? 'badge-success' : 'badge-info'); ?> version-badge">
                            <i class="fas fa-rocket"></i> v<?php echo e($latestVersion); ?>

                        </span>
                    </div>
                </div>
                
                <?php if($updateAvailable): ?>
                    <div class="alert alert-success mt-4">
                        <i class="fas fa-check-circle"></i> 
                        <strong>New Update Available!</strong> 
                        You can update from v<?php echo e($currentVersion); ?> to v<?php echo e($latestVersion); ?>

                        
                        <?php if($updateInfo && isset($updateInfo['description'])): ?>
                            <br><small class="text-muted"><?php echo e($updateInfo['description']); ?></small>
                        <?php endif; ?>
                    </div>
                    
                    <?php if($updateInfo && isset($updateInfo['features']) && is_array($updateInfo['features'])): ?>
                        <div class="alert alert-info">
                            <h6><i class="fas fa-star"></i> What's New in v<?php echo e($latestVersion); ?>:</h6>
                            <ul class="mb-0">
                                <?php $__currentLoopData = array_slice($updateInfo['features'], 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($feature); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if(count($updateInfo['features']) > 3): ?>
                                    <li><em>And <?php echo e(count($updateInfo['features']) - 3); ?> more features...</em></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    
                    <button type="button" class="btn btn-lg btn-primary" id="startUpdateBtn">
                        <i class="fas fa-download"></i> Download & Install Update
                    </button>
                    
                    <p class="mt-2 text-muted">
                        <i class="fas fa-info-circle"></i> 
                        Release Date: <?php echo e($updateInfo['release_date'] ?? 'Unknown'); ?>

                    </p>
                <?php else: ?>
                    <div class="alert alert-info mt-4">
                        <i class="fas fa-check-circle"></i> 
                        You are running the latest version!
                    </div>
                    
                    <button type="button" class="btn btn-lg btn-secondary" id="checkUpdateBtn">
                        <i class="fas fa-sync-alt"></i> Check for Updates
                    </button>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Update Progress Card -->
        <div class="card update-card update-progress" id="updateProgressCard">
            <div class="card-header bg-info">
                <h3 class="card-title"><i class="fas fa-spinner fa-spin"></i> Update in Progress</h3>
            </div>
            <div class="card-body">
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle"></i> 
                    Please do not close this page or refresh until the update is complete.
                </div>
                
                <div id="updateSteps">
                    <!-- Update steps will be added here dynamically -->
                </div>
                
                <div class="progress mt-3">
                    <div class="progress-bar progress-bar-striped progress-bar-animated" 
                         role="progressbar" 
                         id="updateProgressBar" 
                         style="width: 0%">0%</div>
                </div>
            </div>
        </div>
        
        <!-- Changelog Card -->
        <div class="card update-card">
            <div class="card-header bg-success">
                <h3 class="card-title"><i class="fas fa-list-ul"></i> Changelog</h3>
            </div>
            <div class="card-body" id="changelogContainer">
                <div class="text-center">
                    <div class="spinner-border" role="status">
                        <span class="sr-only">Loading...</span>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Backup Information Card -->
        <div class="card update-card">
            <div class="card-header bg-warning">
                <h3 class="card-title"><i class="fas fa-shield-alt"></i> Update Safety</h3>
            </div>
            <div class="card-body">
                <h5><i class="fas fa-check-circle text-success"></i> Automatic Backup</h5>
                <p>Before each update, the system automatically creates a backup of:</p>
                <ul>
                    <li>Application files</li>
                    <li>Configuration files</li>
                    <li>Database structure</li>
                </ul>
                
                <h5 class="mt-3"><i class="fas fa-undo text-info"></i> Automatic Rollback</h5>
                <p>If an update fails, the system will automatically restore from the backup.</p>
                
                <h5 class="mt-3"><i class="fas fa-pause-circle text-warning"></i> Maintenance Mode</h5>
                <p>During the update, the system will be put in maintenance mode to prevent data corruption.</p>
            </div>
        </div>
        
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
$(document).ready(function() {
    
    // Load changelog
    loadChangelog();
    
    // Check for updates button
    $('#checkUpdateBtn').on('click', function() {
        $(this).html('<i class="fas fa-spinner fa-spin"></i> Checking...').prop('disabled', true);
        
        setTimeout(function() {
            location.reload();
        }, 2000);
    });
    
    // Start update button
    $('#startUpdateBtn').on('click', function() {
        if (!confirm('Are you sure you want to update the system?\n\nThe system will be put in maintenance mode during the update.')) {
            return;
        }
        
        $(this).prop('disabled', true);
        $('#updateProgressCard').slideDown();
        
        // Scroll to progress card
        $('html, body').animate({
            scrollTop: $('#updateProgressCard').offset().top - 100
        }, 500);
        
        // Start the update process
        performUpdate();
    });
    
    // Load changelog from server
    function loadChangelog() {
        $.get('/system-update/changelog', function(data) {
            var html = '';
            
            data.forEach(function(version, index) {
                var statusBadge = '';
                var cardClass = 'changelog-item';
                
                if (version.status === 'available') {
                    statusBadge = '<span class="badge badge-success ml-2">Available</span>';
                    cardClass += ' border-success';
                } else if (version.status === 'current') {
                    statusBadge = '<span class="badge badge-primary ml-2">Current</span>';
                    cardClass += ' border-primary';
                }
                
                html += '<div class="' + cardClass + '">';
                html += '<h5><i class="fas fa-tag"></i> Version ' + version.version + statusBadge + ' <small class="text-muted">(' + version.date + ')</small></h5>';
                
                if (version.description) {
                    html += '<p class="text-muted"><i class="fas fa-info-circle"></i> ' + version.description + '</p>';
                }
                
                if (version.changes && version.changes.length > 0) {
                    html += '<h6><i class="fas fa-plus-circle text-success"></i> New Features:</h6>';
                    html += '<ul>';
                    version.changes.forEach(function(change) {
                        html += '<li>' + change + '</li>';
                    });
                    html += '</ul>';
                }
                
                if (version.improvements && version.improvements.length > 0) {
                    html += '<h6><i class="fas fa-arrow-up text-info"></i> Improvements:</h6>';
                    html += '<ul>';
                    version.improvements.forEach(function(improvement) {
                        html += '<li>' + improvement + '</li>';
                    });
                    html += '</ul>';
                }
                
                if (version.bug_fixes && version.bug_fixes.length > 0) {
                    html += '<h6><i class="fas fa-bug text-warning"></i> Bug Fixes:</h6>';
                    html += '<ul>';
                    version.bug_fixes.forEach(function(fix) {
                        html += '<li>' + fix + '</li>';
                    });
                    html += '</ul>';
                }
                
                html += '</div>';
            });
            
            $('#changelogContainer').html(html);
        }).fail(function() {
            $('#changelogContainer').html('<div class="alert alert-danger"><i class="fas fa-exclamation-triangle"></i> Failed to load changelog. Please try refreshing the page.</div>');
        });
    }
    
    // Perform the update
    function performUpdate() {
        var updateSteps = [
            'Putting system in maintenance mode',
            'Creating system backup',
            'Downloading update package',
            'Extracting update files',
            'Running database migrations',
            'Clearing system cache',
            'Taking system online'
        ];
        
        var currentStep = 0;
        var totalSteps = updateSteps.length;
        
        // Add initial steps to UI
        updateSteps.forEach(function(step, index) {
            addUpdateStep(step, 'pending', index);
        });
        
        // Make AJAX call to perform update
        $.ajax({
            url: '/system-update/perform',
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    // Update steps based on response
                    response.steps.forEach(function(step, index) {
                        updateStepStatus(index, step.status, step.message);
                        updateProgress((index + 1) / totalSteps * 100);
                    });
                    
                    // Show success message
                    if (typeof notificationSystem !== 'undefined') {
                        notificationSystem.success('System Updated!', response.message);
                    } else {
                        alert('✅ ' + response.message);
                    }
                    
                    // Reload page after 3 seconds
                    setTimeout(function() {
                        window.location.reload();
                    }, 3000);
                } else {
                    showUpdateError(response.message);
                }
            },
            error: function(xhr) {
                var message = 'Update failed. Please try again or contact support.';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    message = xhr.responseJSON.message;
                }
                showUpdateError(message);
            }
        });
    }
    
    // Add update step to UI
    function addUpdateStep(stepName, status, index) {
        var icon = '<i class="fas fa-circle"></i>';
        if (status === 'success') icon = '<i class="fas fa-check-circle"></i>';
        if (status === 'error') icon = '<i class="fas fa-times-circle"></i>';
        if (status === 'processing') icon = '<i class="fas fa-spinner fa-spin"></i>';
        
        var html = '<div class="update-step ' + status + '" id="step-' + index + '">' +
                   icon + ' <strong>' + stepName + '</strong>' +
                   '<span class="step-message"></span>' +
                   '</div>';
        
        $('#updateSteps').append(html);
    }
    
    // Update step status
    function updateStepStatus(index, status, message) {
        var $step = $('#step-' + index);
        $step.removeClass('pending processing success error').addClass(status);
        
        var icon = '<i class="fas fa-circle"></i>';
        if (status === 'success') icon = '<i class="fas fa-check-circle"></i>';
        if (status === 'error') icon = '<i class="fas fa-times-circle"></i>';
        if (status === 'processing') icon = '<i class="fas fa-spinner fa-spin"></i>';
        
        $step.find('i').replaceWith(icon);
        
        if (message) {
            $step.find('.step-message').html(' - ' + message);
        }
    }
    
    // Update progress bar
    function updateProgress(percent) {
        percent = Math.round(percent);
        $('#updateProgressBar').css('width', percent + '%').text(percent + '%');
    }
    
    // Show update error
    function showUpdateError(message) {
        $('#updateSteps').append(
            '<div class="alert alert-danger mt-3">' +
            '<i class="fas fa-exclamation-triangle"></i> <strong>Update Failed:</strong> ' + message +
            '</div>'
        );
        
        if (typeof notificationSystem !== 'undefined') {
            notificationSystem.showError(message, 'Update Failed');
        } else {
            alert('❌ Update Failed: ' + message);
        }
        
        setTimeout(function() {
            location.reload();
        }, 5000);
    }
    
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\pos v24.4\resources\views/system/update.blade.php ENDPATH**/ ?>